/*
 * Decompiled with CFR 0.152.
 */
package jade.core.behaviours;

import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.BehaviourList;
import jade.core.behaviours.CompositeBehaviour;
import jade.util.leap.Collection;
import jade.util.leap.Iterator;
import java.util.Hashtable;

public class ParallelBehaviour
extends CompositeBehaviour {
    public static final int WHEN_ALL = 0;
    public static final int WHEN_ANY = 1;
    private int whenToStop;
    private BehaviourList subBehaviours = new BehaviourList();
    private Hashtable blockedChildren = new Hashtable();
    private BehaviourList terminatedChildren = new BehaviourList();

    public ParallelBehaviour() {
        this.whenToStop = 0;
    }

    public ParallelBehaviour(int endCondition) {
        this.whenToStop = endCondition;
    }

    public ParallelBehaviour(Agent a, int endCondition) {
        super(a);
        this.whenToStop = endCondition;
    }

    protected void scheduleFirst() {
        this.subBehaviours.begin();
        Behaviour b = this.subBehaviours.getCurrent();
        if (b != null && this.blockedChildren.size() < this.subBehaviours.size()) {
            while (!b.isRunnable()) {
                b = this.subBehaviours.next();
            }
        }
    }

    protected void scheduleNext(boolean currentDone, int currentResult) {
        Behaviour b = this.subBehaviours.next();
        if (b != null && this.blockedChildren.size() < this.subBehaviours.size()) {
            while (!b.isRunnable()) {
                b = this.subBehaviours.next();
            }
        }
    }

    protected boolean checkTermination(boolean currentDone, int currentResult) {
        if (currentDone) {
            Behaviour b = this.subBehaviours.getCurrent();
            this.subBehaviours.removeElement(b);
            b.setParent(null);
            this.terminatedChildren.addElement(b);
        }
        if (!this.evalCondition()) {
            if (this.blockedChildren.size() == this.subBehaviours.size()) {
                this.myEvent.init(false, -1);
                super.handle(this.myEvent);
            }
            return false;
        }
        return true;
    }

    protected Behaviour getCurrent() {
        return this.subBehaviours.getCurrent();
    }

    public Collection getChildren() {
        return this.subBehaviours;
    }

    public void addSubBehaviour(Behaviour b) {
        this.subBehaviours.addElement(b);
        b.setParent(this);
        b.setAgent(this.myAgent);
        if (b.isRunnable()) {
            if (!this.isRunnable()) {
                this.myEvent.init(true, -1);
                super.handle(this.myEvent);
                if (this.myAgent != null) {
                    this.myAgent.notifyRestarted(this);
                }
                this.currentExecuted = true;
            }
        } else {
            this.blockedChildren.put(b, b);
        }
    }

    public void removeSubBehaviour(Behaviour b) {
        this.terminatedChildren.removeElement(b);
        boolean rc = this.subBehaviours.removeElement(b);
        if (rc) {
            b.setParent(null);
        }
        if (!b.isRunnable()) {
            this.blockedChildren.remove(b);
        } else if (!this.subBehaviours.isEmpty() && this.blockedChildren.size() == this.subBehaviours.size()) {
            this.myEvent.init(false, -1);
            super.handle(this.myEvent);
        }
    }

    public void reset() {
        this.blockedChildren.clear();
        this.terminatedChildren.begin();
        Behaviour b = this.terminatedChildren.getCurrent();
        while (b != null) {
            this.terminatedChildren.removeElement(b);
            b.setParent(this);
            this.subBehaviours.addElement(b);
            b = this.terminatedChildren.next();
        }
        this.subBehaviours.begin();
        super.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handle(Behaviour.RunnableChangedEvent rce) {
        block10: {
            BehaviourList behaviourList = this.subBehaviours;
            synchronized (behaviourList) {
                Behaviour b;
                block8: {
                    Behaviour b2;
                    block11: {
                        block9: {
                            if (!rce.isUpwards()) break block8;
                            b2 = rce.getSource();
                            if (b2 != this) break block9;
                            super.handle(rce);
                            break block10;
                        }
                        if (!rce.isRunnable()) break block11;
                        Object rc = this.blockedChildren.remove(b2);
                        if (rc != null && !this.isRunnable()) {
                            this.myEvent.init(true, -1);
                            super.handle(this.myEvent);
                            this.currentExecuted = true;
                        }
                        break block10;
                    }
                    Behaviour rc = this.blockedChildren.put(b2, b2);
                    if (rc == null || this.blockedChildren.size() != this.subBehaviours.size()) break block10;
                    this.myEvent.init(false, -1);
                    super.handle(this.myEvent);
                    break block10;
                }
                boolean r = rce.isRunnable();
                this.setRunnable(r);
                Iterator it = this.getChildren().iterator();
                while (it.hasNext()) {
                    b = (Behaviour)it.next();
                    b.handle(rce);
                }
                if (r) {
                    this.blockedChildren.clear();
                } else {
                    it = this.getChildren().iterator();
                    while (it.hasNext()) {
                        b = (Behaviour)it.next();
                        this.blockedChildren.put(b, b);
                    }
                }
            }
        }
    }

    private boolean evalCondition() {
        boolean cond;
        switch (this.whenToStop) {
            case 0: {
                cond = this.subBehaviours.isEmpty();
                break;
            }
            case 1: {
                cond = this.terminatedChildren.size() > 0;
                break;
            }
            default: {
                cond = this.terminatedChildren.size() >= this.whenToStop;
            }
        }
        return cond;
    }
}

